<?php
/**
 * @package        Alter Fields
 * @copyright      Copyright (C) 2022-2023 AlterBrains.com. All rights reserved.
 * @license        https://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

use AlterBrains\Plugin\System\Alterfields\Extension\Alterfields;

return new class () implements ServiceProviderInterface {
    /**
     * @inheritDoc
     * @since 3.0.0
     */
    public function register(Container $container): void
    {
        if (!Factory::getApplication()->isClient('administrator')) {
            return;
        }

        $container->set(
            PluginInterface::class,
            function (Container $container) {
                $plugin = new Alterfields((array)PluginHelper::getPlugin('system', 'alterfields'));
                $plugin->setDatabase($container->get('DatabaseDriver'));

                return $plugin;
            }
        );
    }
};
