<?php
/**
 * @package        Direct Alias
 * @copyright      Copyright (C) 2009-2023 AlterBrains.com. All rights reserved.
 * @license        https://www.gnu.org/licenses/old-licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

use AlterBrains\Plugin\System\Directalias\Extension\Directalias;

return new class () implements ServiceProviderInterface {
    /**
     * @inheritDoc
     * @since 3.0.0
     */
    public function register(Container $container)
    {
        $container->set(
            PluginInterface::class,
            function (/*Container $container*/) {
                $plugin = new Directalias((array)PluginHelper::getPlugin('system', 'directalias'));
                $plugin->setApplication(Factory::getApplication());

                return $plugin;
            }
        );
    }
};
