<?php
/**
 * @package        AJAX Toggler
 * @copyright      Copyright (C)  2009 - 2023 AlterBrains.com. All rights reserved.
 * @license        GNU/GPL, see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;

use AlterBrains\Plugin\System\Ajaxtoggler\Extension\Ajaxtoggler;

return new class () implements ServiceProviderInterface {
    /**
     * @inheritDoc
     * @since 4.0.0
     */
    public function register(Container $container): void
    {
        if (!Factory::getApplication()->isClient('administrator') || !Factory::getApplication()->getIdentity()->id) {
            return;
        }

        $container->set(
            PluginInterface::class,
            function (/*Container $container*/) {
                return new Ajaxtoggler((array) PluginHelper::getPlugin('system', 'ajaxtoggler'));
            }
        );
    }
};
