<?php
/**
 * @package        Alter Fields
 * @copyright      Copyright (C) 2022-2022 AlterBrains.com. All rights reserved.
 * @license        http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

use Joomla\CMS\Factory;

defined('_JEXEC') or die();

/**
 * @since        1.0
 * @noinspection PhpUnused
 */
class plgSystemAlterFieldsInstallerScript
{
	/**
	 * @var string
	 * @since 3.0
	 */
	protected $extension_name = 'System - Alter Fields';

	public function install()
	{
		Factory::getApplication()->enqueueMessage(sprintf('Successfully installed "%s" plugin.', $this->extension_name));
	}

	public function update()
	{
		Factory::getApplication()->enqueueMessage(sprintf('Successfully updated "%s" plugin.', $this->extension_name));
	}

	public function uninstall()
	{
		Factory::getApplication()->enqueueMessage(sprintf('Successfully uninstalled "%s" plugin.', $this->extension_name));
	}
}
